<?php
class Mahasiswa_model {
    private $table = "mahasiswa",
            $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getDataMhs() {
        $this->db->query("SELECT * FROM $this->table ORDER BY id DESC");
        return $this->db->resultSet();
    }

    public function getMhsById($id) {
        $this->db->query("SELECT * FROM $this->table WHERE id=:id");
        $this->db->bind("id", $id);

        return $this->db->single();
    }

    public function addMhs($data) {
        $query = "INSERT INTO mahasiswa
                    VALUES(
                        NULL, :nama, :nrp, :email, :jurusan
                    );
                ";
        
        $this->db->query($query);
        $this->db->bind("nama", $data["nama"]);
        $this->db->bind("nrp", $data["nrp"]);
        $this->db->bind("email", $data["email"]);
        $this->db->bind("jurusan", $data["jurusan"]);

        $this->db->execute();

        return $this->db->rowCount();
    }

    public function delMhs($id) {
        $query = "DELETE FROM mahasiswa WHERE id = :id";

        $this->db->query($query);
        $this->db->bind("id", $id);

        $this->db->execute();

        return $this->db->rowCount();
    }

    public function editMhs($data) {
        $query = "UPDATE mahasiswa SET nama=:nama, nrp=:nrp, email=:email, jurusan=:jurusan WHERE id = :id ";

        try {
            $this->db->query($query);

            $this->db->bind("nama", $data["nama"]);
            $this->db->bind("nrp", $data["nrp"]);
            $this->db->bind("email", $data["email"]);
            $this->db->bind("jurusan", $data["jurusan"]);
            $this->db->bind("id", (int) $data["id"]);

            $this->db->execute();
        } catch(PDOException $e) {
            return $e;
        }

        return $this->db->rowCount();
    }
}