<?php
class Mahasiswa extends Controller{
    public function index() {
        $data["page_title"] = "Daftar Mahasiswa";
        $data["mahasiswa"] = $this->model("Mahasiswa_model")->getDataMhs();
        $data["nav_type"] = "Main";

        $this->view("templates/header", $data);
        $this->view("templates/navigation", $data);
        $this->view("mahasiswa/index", $data);
        $this->view("templates/footer");
    }

    public function detail($id) {
        $data["page_title"] = "Detail Mahasiswa";
        $data["mahasiswa"] = $this->model("Mahasiswa_model")->getMhsById($id);
        $data["nav_type"] = "Main";

        $this->view("templates/header", $data);
        $this->view("templates/navigation", $data);
        $this->view("mahasiswa/detail", $data);
        $this->view("templates/footer");
    }

    public function tambah() {
        if($this->model("Mahasiswa_model")->addMhs($_POST) > 0) {
            Flash::setFlash("Berhasil!", "ditambahkan", "success");
            header("Location: " . BASE_URL . "mahasiswa");
        } else{
            Flash::setFlash("Gagal!", "ditambahkan", "danger");
        }
    }

    public function delete($id) {
        if($this->model("Mahasiswa_model")->delMhs($id) > 0) {
            Flash::setFlash("Berhasil!", "dihapus", "success");
            header("Location: " . BASE_URL . "mahasiswa");
        } else{
            Flash::setFlash("Gagal!", "dihapus", "danger");
        }
    }

    public function getEdit() {
        echo json_encode($this->model("Mahasiswa_model")->getMhsById($_POST["id"]));
    }

    public function edit() {
        if($this->model("Mahasiswa_model")->editMhs($_POST) > 0) {
            Flash::setFlash("Berhasil!", "diubah", "success");
            header("Location: " . BASE_URL . "mahasiswa");
        } else{
            Flash::setFlash("Gagal!", "diubah", "danger");
        }
    }
}
?>